<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductVariation extends Model 
{

    protected $table = 'products_variations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function abstracts()
    {
        return $this->morphMany('App\Models\Product\ProductAbstraction', 'abstractable');
    }

    public function products_instances()
    {
        return $this->hasMany('App\Models\Product\ProductInstance', 'product_instance_id');
    }

    public function product()
    {
        return $this->belongsTo('App\Models\Product\Product', 'product_id');
    }

}